#pragma once
#include "stdafx.h"

// CPCanIsoTpExampleDlgAddNewMappings dialog
class CPCanIsoTpExampleDlgAddNewMappings : public CDialogEx
{
	DECLARE_DYNAMIC(CPCanIsoTpExampleDlgAddNewMappings)
public:
	CPCanIsoTpExampleDlgAddNewMappings(CWnd* pParent = NULL);   // standard constructor
	virtual ~CPCanIsoTpExampleDlgAddNewMappings();
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_PCANISOTPEXAMPLE_ADD_NEW_MAPPINGS };
#endif

public_member:
	/// <summary>
	/// CAN ID to map to CAN-ISO-TP network addressing information
	/// </summary>
	UINT32 m_canId;
	/// <summary>
	/// CAN ID used by the other side to internally respond to the CAN-ISO-TP segmented frames
	/// (i.e. the Flow Control frames will use this ID)
	/// </summary>
	UINT32 m_canIdResponse;
	/// <summary>
	/// The CAN ID type used by the mapping (11 bits or 29 bits CAN ID)
	/// </summary>
	TPCANTPIdType m_canIdType;
	/// <summary>
	/// Type of CAN-ISO-TP message (diagnostic or remote disgnostic message)
	/// </summary>
	TPCANTPMessageType m_msgType;
	/// <summary>
	/// The ISO-TP network addressing format.
	/// </summary>
	TPCANTPFormatType m_formatType;
	/// <summary>
	/// Type of addressing (physical: -node to node-, or functional: -node to all-)
	/// </summary>
	TPCANTPAddressingType m_targetType;
	/// <summary>
	/// Source address
	/// </summary>
	byte m_sourceAddr;
	/// <summary>
	/// Target address
	/// </summary>
	byte m_targetAddr;
	/// <summary>
	/// Remote address (used only with remote disgnostic message)
	/// </summary>
	byte m_remoteAddr;
	//Message Type
	std::vector<std::pair<BYTE, CString>> m_listOfMsgType{  { PCANTP_MESSAGE_DIAGNOSTIC,		 L"PCANTP_MESSAGE_DIAGNOSTIC" },
													        { PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,  L"PCANTP_MESSAGE_REMOTE_DIAGNOSTIC" } };
	// Addressing Type
	std::vector<std::pair<BYTE, CString>> m_listOfAddrType{ { PCANTP_ADDRESSING_PHYSICAL,		 L"PCANTP_ADDRESSING_PHYSICAL" },
													        { PCANTP_ADDRESSING_FUNCTIONAL,		 L"PCANTP_ADDRESSING_FUNCTIONAL" } };
public_method:
	void UpdateAddNewMappingButton();
	void UpdateUi();
	void PopulateComboBox();
	void FillComboBoxFormatType(TPCANTPIdType idType, TPCANTPMessageType msgType);
	TPCANTPIdType GetSelectedIdType();
	TPCANTPMessageType GetSelectedMsgType();
	TPCANTPFormatType GetSelectedFormatType();
	TPCANTPAddressingType GetSelectedTargetType();
	INT_PTR CheckMapping();

protected_method:
	DECLARE_MESSAGE_MAP()
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	afx_msg void OnCbnSelchangeComboMessageType();
	afx_msg void OnBnClickedButtonAddMapping();
	afx_msg void OnBnClickedButtonCancelNewMapping();
	afx_msg void OnBnClickedRadio11bits();
	afx_msg void OnBnClickedRadio29bits();
	afx_msg void OnCbnSelchangeComboFormatType();
	afx_msg void OnCbnSelchangeComboAddressingType();
	afx_msg void OnDeltaposSpinCanId(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDeltaposSpinCanIdResponse(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDeltaposSpinSourceAddress(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDeltaposSpinTargetAddress(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDeltaposSpinRemoteAddress(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnEnChangeEditCanId();
	afx_msg void OnEnChangeEditCanIdResponse();
	afx_msg void OnEnChangeEditSourceAddress();
	afx_msg void OnEnChangeEditTargetAddress();
	afx_msg void OnEnChangeEditRemoteAddress();

public_properties:
	// Dialog Data
	CButton radioButtonCanId11b;
	CButton radioButtonCanId29b;
	CButton buttonCancel;
	CComboBox comboBoxMsgType;
	CComboBox comboBoxFormat;
	CComboBox comboBoxTargetType;
	CSpinButtonCtrl numericUpDownCanId;
	CSpinButtonCtrl numericUpDownCanIdResp;
	CSpinButtonCtrl numericUpDownSourceAddr;
	CSpinButtonCtrl numericUpDownTargetAddr;
	CSpinButtonCtrl numericUpDownRemoteAddr;
	CEdit editCanID;
	CEdit editCanIdResp;
	CEdit editSourceAddr;
	CEdit editTargetAddr;
	CEdit editRemoteAddr;
};
